using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Fiche3Recap
{
    public partial class Fm_service : Form
    {
        public Fm_service()
        {
            InitializeComponent();
        }

        private void Fm_service_Load(object sender, EventArgs e)
        {
            this.ta_service.Fill(this.ds_service.service);
            ds_service.service.serviceRowChanged += new Ds_service.serviceRowChangeEventHandler(service_serviceRowChangedOrDeleted);
            ds_service.service.serviceRowDeleted += new Ds_service.serviceRowChangeEventHandler(service_serviceRowChangedOrDeleted);
        }

        void service_serviceRowChangedOrDeleted(object sender, Ds_service.serviceRowChangeEvent e)
        {
            if ((e.Action == DataRowAction.Add) || (e.Action == DataRowAction.Change) || (e.Action == DataRowAction.Delete))
            {
                try
                {
                    ta_service.Update(e.Row);
                }
                catch (Exception pb)
                {
                    MessageBox.Show("Erreur SGBD : " + pb.ToString());
                    e.Row.RejectChanges();
                }
            }
        }
        
        private void bindingNavigatorDeleteItem_Click(object sender, EventArgs e)
        {
            try
            {
                bs_service.RemoveCurrent();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
            }
        }

        private void bn_service_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            if ((e.ClickedItem.Text!="Supprimer")&&(e.ClickedItem!=bn_service.CountItem))
            {
                try
                {
                    bs_service.EndEdit();
                }
                catch (Exception pb)
                {
                    MessageBox.Show("Erreur DATASET : " + pb.ToString());
                    bs_service.CancelEdit();
                }
            }
        }

    }
}