using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Fiche3
{
    public partial class Fm_service : Form
    {
        public Fm_service()
        {
            InitializeComponent();
        }

        private void Fm_service_Load(object sender, EventArgs e)
        {
            ds_service.EnforceConstraints = false;
            this.ta_employe.Fill(this.ds_service.employe);
            this.ta_service.Fill(this.ds_service.service);
            ds_service.EnforceConstraints = true;
            ds_service.service.serviceRowChanged += new Ds_service.serviceRowChangeEventHandler(service_serviceRowChangedOrDeleted);
            ds_service.service.serviceRowDeleted += new Ds_service.serviceRowChangeEventHandler(service_serviceRowChangedOrDeleted);
            bs_service.PositionChanged += new EventHandler(affichePosCpt);
            affichePosCpt(null, null);
            //affichePosCpt();
        }

        private void affichePosCpt(object sender, EventArgs e)
        {
            tb_posCpt.Text = bs_service.Position + 1 + "/" + bs_service.Count;
        }

        void service_serviceRowChangedOrDeleted(object sender, Ds_service.serviceRowChangeEvent e)
        {
            if ((e.Action==DataRowAction.Add)||(e.Action==DataRowAction.Change)||(e.Action==DataRowAction.Delete))
            {
                try
                {
                    ta_service.Update(e.Row);
                }
                catch (Exception pb)
                {
                    MessageBox.Show("Erreur SGBD : " + pb.ToString());
                    e.Row.RejectChanges();
                }
            }
        }

        //private void affichePosCpt()
        //{
        //    tb_posCpt.Text = bs_service.Position + 1 + "/" + bs_service.Count;
        //}

        private void bt_premier_Click(object sender, EventArgs e)
        {
            try
            {
                bs_service.MoveFirst();
                //affichePosCpt();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs_service.CancelEdit();
            }
        }

        private void bt_precedent_Click(object sender, EventArgs e)
        {
            try
            {
                bs_service.MovePrevious();
                //affichePosCpt();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs_service.CancelEdit();
            }
        }

        private void bt_suivant_Click(object sender, EventArgs e)
        {
            try
            {
                bs_service.MoveNext();
                //affichePosCpt();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs_service.CancelEdit();
            }
        }

        private void bt_dernier_Click(object sender, EventArgs e)
        {
            try
            {
                bs_service.MoveLast();
                //affichePosCpt();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs_service.CancelEdit();
            }
        }

        private void bt_ajouter_Click(object sender, EventArgs e)
        {
            try
            {
                bs_service.AddNew();
                //affichePosCpt();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs_service.CancelEdit();
            }
        }

        private void bt_supprimer_Click(object sender, EventArgs e)
        {
            try
            {
                bs_service.RemoveCurrent();
                //affichePosCpt();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs_service.CancelEdit();
            }
        }

        private void bt_ok_Click(object sender, EventArgs e)
        {
            try
            {
                bs_service.EndEdit();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
                bs_service.CancelEdit();
            }
        }

        private void bindingNavigatorDeleteItem_Click(object sender, EventArgs e)
        {
            try
            {
                bs_service.RemoveCurrent();
            }
            catch (Exception pb)
            {
                MessageBox.Show("Erreur DATASET : " + pb.ToString());
            }
        }

        private void bn_service_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            if ((e.ClickedItem.Text != "Supprimer") && (e.ClickedItem != bn_service.CountItem))
            {
                try
                {
                    bs_service.EndEdit();
                }
                catch (Exception pb)
                {
                    MessageBox.Show("Erreur DATASET : " + pb.ToString());
                    bs_service.CancelEdit();
                }
            }
        }
    }
}