using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Fiche2
{
    public partial class Fm_principal : Form
    {
        private string fichierCourant = "";
        public Fm_principal()
        {
            InitializeComponent();
        }

        private void mi_quitter_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void mi_ouvrir_Click(object sender, EventArgs e)
        {
            if (od_ouvrir.ShowDialog() == DialogResult.OK)
            {
                rt_texte.LoadFile(od_ouvrir.FileName, RichTextBoxStreamType.PlainText);
                fichierCourant = od_ouvrir.FileName;
            }
        }

        private void mi_enregistrerSous_Click(object sender, EventArgs e)
        {
            if (sd_enregistrer.ShowDialog()==DialogResult.OK)
            {
                rt_texte.SaveFile(sd_enregistrer.FileName, RichTextBoxStreamType.PlainText);
                fichierCourant = sd_enregistrer.FileName;
            }
        }

        private void mi_nouveau_Click(object sender, EventArgs e)
        {
            rt_texte.Clear();
            fichierCourant = "";
        }

        private void mi_enregistrer_Click(object sender, EventArgs e)
        {
            if (fichierCourant!="")
            {
                rt_texte.SaveFile(fichierCourant, RichTextBoxStreamType.PlainText);
            }
        }

        private void mi_annuler_Click(object sender, EventArgs e)
        {
            rt_texte.Undo();
        }

        private void mi_retablir_Click(object sender, EventArgs e)
        {
            rt_texte.Redo();
        }

        private void mi_copier_Click(object sender, EventArgs e)
        {
            rt_texte.Copy();
        }

        private void mi_couper_Click(object sender, EventArgs e)
        {
            rt_texte.Cut();
        }

        private void mi_coller_Click(object sender, EventArgs e)
        {
            rt_texte.Paste();
        }

    }
}