using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Fiche1Exo
{
    public partial class Fm_principal : Form
    {
        public Fm_principal()
        {
            InitializeComponent();
        }

        private void transferer(ListBox source, ListBox destination)
        {
            if (source.SelectedIndex==-1)
            {
                MessageBox.Show("Vous devez d'abord slectionner un lment dans la liste de " + source.Tag);
            }
            else
            {
                destination.Items.Add(source.Items[source.SelectedIndex]);
                source.Items.RemoveAt(source.SelectedIndex);
            }
        }

        private void ajouter(TextBox tb, ListBox liste)
        {
            if (tb.Text=="")
            {
                MessageBox.Show("Vous devez d'abord saisir un lment dans la zone de " + liste.Tag);
            }
            else
            {
                liste.Items.Add(tb.Text);
                tb.Clear();
                tb.Focus();
            }
        }

        private void supprimer(ListBox liste)
        {
            if (liste.SelectedIndex==-1)
            {
                MessageBox.Show("Vous devez d'abord slectionner l'lment  supprimer de la liste de " + liste.Tag);
            }
            else
            {
                liste.Items.RemoveAt(liste.SelectedIndex);
            }
        }

        private void bt_versDroite_Click(object sender, EventArgs e)
        {
            transferer(lb_liste1, lb_liste2);
        }

        private void bt_versGauche_Click(object sender, EventArgs e)
        {
            transferer(lb_liste2, lb_liste1);
        }

        private void bt_plusGauche_Click(object sender, EventArgs e)
        {
            ajouter(tb_1, lb_liste1);
        }

        private void bt_plusDroit_Click(object sender, EventArgs e)
        {
            ajouter(tb_2, lb_liste2);
        }

        private void bt_moinsGauche_Click(object sender, EventArgs e)
        {
            supprimer(lb_liste1);
        }

        private void bt_moinsDroit_Click(object sender, EventArgs e)
        {
            supprimer(lb_liste2);
        }

        private void bt_quitter_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("Voulez-vous rellement quitter ?", "Confirmation", MessageBoxButtons.YesNo) == DialogResult.Yes)
            {
                Application.Exit();
            }
        }
    }
}