﻿using System;
using System.Collections.Generic;
using System.Data.Services;
using System.Data.Services.Common;
using System.Linq;
using System.ServiceModel.Web;
using System.Web;
using DAO_GSB;

namespace APP_GSB_REST
{
    public class WcfDataServiceGSB : DataService< bdMedecinsEntities >
    {
        // Cette méthode n'est appelée qu'une seule fois pour initialiser les stratégies au niveau des services.
        public static void InitializeService(DataServiceConfiguration config)
        {
             config.SetEntitySetAccessRule("medecin", EntitySetRights.All); // obligatoire
             config.SetServiceOperationAccessRule("departement", ServiceOperationRights.AllRead);
             config.SetServiceOperationAccessRule("lesDepartements", ServiceOperationRights.AllRead);
           //  config.UseVerboseErrors = true;
             config.DataServiceBehavior.MaxProtocolVersion = DataServiceProtocolVersion.V2;
           
        }

        [WebGet]
        public List<int> lesDepartements()
        {
            return medecin.lesDepartements();
        }
        [WebGet]
        public IQueryable<medecin> departement(int num)
        {
            return medecin.lesMedecins(num).AsQueryable<medecin>();
        }
        protected override void HandleException(HandleExceptionArgs args)
        {
        //   if(args.Exception.InnerException is )
        //   {
               
            string s = args.Exception.InnerException.Message;
               Console.WriteLine("HttpException");
           throw new DataServiceException(400,s);
           

           
        }
        
    }
}
